﻿---
title: Elastic APM release notes
description: Review the changes, fixes, and more in each version of Elastic APM. To check for security updates, go to Security announcements for the Elastic stack...
url: https://www.elastic.co/docs/release-notes/apm
products:
  - APM
  - APM Server
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Elastic APM release notes
Review the changes, fixes, and more in each version of Elastic APM.
To check for security updates, go to [Security announcements for the Elastic stack](https://discuss.elastic.co/c/announcements/security-announcements/31).

## 9.3.0

_No new features or enhancements_
_No new fixes_

## 9.2.5

<applies-to>
  - Elastic Stack: Generally available since 9.2
</applies-to>


### Fixes

- Fix potential data race in Tail Based Sampling ([#20139](https://github.com/elastic/apm-server/pull/20139))
- Fix self-instrumentation missing span kind in some traces ([#20199](https://github.com/elastic/apm-server/pull/20199)) ([#20212](https://github.com/elastic/apm-server/pull/20212))


## 9.2.4

_No new features, enhancements, or fixes._

## 9.2.3

_No new features, enhancements, or fixes._

## 9.2.2

_No new features, enhancements, or fixes._

## 9.2.1

<applies-to>
  - Elastic Stack: Generally available since 9.2
</applies-to>


### Fixes

- Fix build pipeline to ensure resulting binary info shows `vcs.modified=false` ([#19252](https://github.com/elastic/apm-server/pull/19252))


## 9.2.0

<applies-to>
  - Elastic Stack: Generally available since 9.2
</applies-to>


### Features and enhancements

- [Failure store](https://www.elastic.co/docs/manage-data/data-store/data-streams/failure-store) enabled for all new datastreams. This is applied through [elasticsearch#131296](https://github.com/elastic/elasticsearch/pull/131296) and [elasticsearch#131395](https://github.com/elastic/elasticsearch/pull/131395)


### Fixes

- Fix `output.elasticsearch.bulk_requests.available` metric to correctly report the available bulk indexers [#18953](https://github.com/elastic/apm-server/pull/18953)


## 9.1.10

_No new features, enhancements, or fixes._

## 9.1.9

_No new features, enhancements, or fixes._

## 9.1.8

_No new features, enhancements, or fixes._

## 9.1.7


### Fixes

- Fix build pipeline to ensure resulting binary info shows `vcs.modified=false` ([#19252](https://github.com/elastic/apm-server/pull/19252))


## 9.1.6


### Fixes

- Fix `output.elasticsearch.bulk_requests.available` metric to correctly report the available bulk indexers [#18953](https://github.com/elastic/apm-server/pull/18953)


## 9.1.5


### Fixes

- APM Integration on ECH or ECE uses recommended frozen values for infrastructure related configs. The fix is applied through [kibana#235306](https://github.com/elastic/kibana/pull/235306)


## 9.1.4

_No new features, enhancements, or fixes._

## 9.1.3

_No new features, enhancements, or fixes._

## 9.1.2

_No new features, enhancements, or fixes._

## 9.1.1


### Fixes

- Fix Fleet-managed apm-server hanging or crashing on config hot reload due to duplicate monitoring registry ([#17872](https://github.com/elastic/apm-server/pull/17872))


## 9.1.0


### Features and enhancements

- Add config for tail-based sampling discard on write ([#13950](https://github.com/elastic/integrations/pull/13950))
- Add config for tail-based sampling TTL ([#16579](https://github.com/elastic/apm-server/pull/16579))


### Fixes

- Truncate string slice attributes in OTLP labels ([#434](https://github.com/elastic/apm-data/pull/434))
- Fix broken UI by explicitly enabling date detection for the `system.process.cpu.start_time` field ([#130466](https://github.com/elastic/elasticsearch/pull/130466))
- Use representative count for the `event.success_count` metric if available ([#119995](https://github.com/elastic/elasticsearch/pull/119995))
- Fix setting `event.dataset` to `data_stream.dataset` if `event.dataset` is empty, to have `event.dataset` in every `logs-*` data stream ([#129074](https://github.com/elastic/elasticsearch/pull/129074))
- Fix missing trusted root certificate authority in the docker image ([#16928](https://github.com/elastic/apm-server/pull/16928))


## 9.0.8


### Fixes

- APM Integration on ECH or ECE uses recommended frozen values for infrastructure related configs. The fix is applied through [kibana#235306](https://github.com/elastic/kibana/pull/235306).


## 9.0.7

_No new features, enhancements, or fixes._

## 9.0.6

_No new features, enhancements, or fixes._

## 9.0.5

_No new features, enhancements, or fixes._

## 9.0.4


### Fixes

- Tail-based sampling: Fix missing or infrequent monitoring metric `lsm_size` and `value_log_size` ([#17512](https://github.com/elastic/apm-server/pull/17512))
- Fix default tracer `http request sent to https endpoint` error when both self-instrumentation and TLS are enabled ([#17293](https://github.com/elastic/apm-server/pull/17293))


## 9.0.3


### Features and enhancements

- Tail-based sampling: Optimize performance for instances with more CPU and memory ([#17254](https://github.com/elastic/apm-server/pull/17254))


### Fixes

- Tail-based sampling: Fix ever-increasing dynamic group count monitoring metric ([#17042](https://github.com/elastic/apm-server/pull/17042))
- Tail-based sampling: Fix incorrectly large pebble database `lsm_size` monitoring metric in edge cases which causes TBS to be bypassed ([#17149](https://github.com/elastic/apm-server/pull/17149))
- Tail-based sampling: Log pubsub errors at error or warn level ([#17135](https://github.com/elastic/apm-server/pull/17135))


## 9.0.2


### Fixes

- Fix missing trusted root certificate authority in the docker image ([#16928](https://github.com/elastic/apm-server/pull/16928))


## 9.0.1


### Fixes

- Tail-based sampling: ignore subscriber position read error and proceed as if file does not exist to avoid crash looping ([#16736](https://github.com/elastic/apm-server/pull/16736))


## 9.0.0


### Features and enhancements

- **Tail-based sampling**: Storage layer is rewritten to use Pebble database instead of BadgerDB. The new implementation offers a substantial throughput increase while consuming significantly less memory. Disk usage is significantly lower and more stable. See APM [Transaction sampling](https://www.elastic.co/docs/solutions/observability/apm/transaction-sampling) docs for benchmark details. ([#15235](https://github.com/elastic/apm-server/pull/15235))


### Fixes

- Fix overflow in validation of `apm-server.agent.config.cache.expiration` on 32-bit architectures. ([#15216](https://github.com/elastic/apm-server/pull/15216))
- Change permissions of `apm-server.yml` in `tar.gz` artifacts to `0600`. ([#15627](https://github.com/elastic/apm-server/pull/15627))