﻿---
title: Analyzer reference
description: Elasticsearch ships with a wide range of built-in analyzers, which can be used in any index without further configuration: If you do not find an analyzer...
url: https://www.elastic.co/docs/reference/text-analysis/analyzer-reference
products:
  - Elasticsearch
---

# Analyzer reference
Elasticsearch ships with a wide range of built-in analyzers, which can be used in any index without further configuration:
<definitions>
  <definition term="Standard Analyzer">
    The `standard` analyzer divides text into terms on word boundaries, as defined by the Unicode Text Segmentation algorithm. It removes most punctuation, lowercases terms, and supports removing stop words.
  </definition>
  <definition term="Simple Analyzer">
    The `simple` analyzer divides text into terms whenever it encounters a character which is not a letter. It lowercases all terms.
  </definition>
  <definition term="Whitespace Analyzer">
    The `whitespace` analyzer divides text into terms whenever it encounters any whitespace character. It does not lowercase terms.
  </definition>
  <definition term="Stop Analyzer">
    The `stop` analyzer is like the `simple` analyzer, but also supports removal of stop words.
  </definition>
  <definition term="Keyword Analyzer">
    The `keyword` analyzer is a noop analyzer that accepts whatever text it is given and outputs the exact same text as a single term.
  </definition>
  <definition term="Pattern Analyzer">
    The `pattern` analyzer uses a regular expression to split the text into terms. It supports lower-casing and stop words.
  </definition>
  <definition term="Language Analyzers">
    Elasticsearch provides many language-specific analyzers like `english` or `french`.
  </definition>
  <definition term="Fingerprint Analyzer">
    The `fingerprint` analyzer is a specialist analyzer which creates a fingerprint which can be used for duplicate detection.
  </definition>
</definitions>


## Custom analyzers

If you do not find an analyzer suitable for your needs, you can create a [`custom`](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer) analyzer which combines the appropriate [character filters](https://www.elastic.co/docs/reference/text-analysis/character-filter-reference), [tokenizer](https://www.elastic.co/docs/reference/text-analysis/tokenizer-reference), and [token filters](https://www.elastic.co/docs/reference/text-analysis/token-filter-reference).