﻿---
title: Whitespace tokenizer
description: The whitespace tokenizer breaks text into terms whenever it encounters a whitespace character. The above sentence would produce the following terms: The...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-whitespace-tokenizer
products:
  - Elasticsearch
---

# Whitespace tokenizer
The `whitespace` tokenizer breaks text into terms whenever it encounters a whitespace character.

## Example output

```json

{
  "tokenizer": "whitespace",
  "text": "The 2 QUICK Brown-Foxes jumped over the lazy dog's bone."
}
```

The above sentence would produce the following terms:
```text
[ The, 2, QUICK, Brown-Foxes, jumped, over, the, lazy, dog's, bone. ]
```


## Configuration

The `whitespace` tokenizer accepts the following parameters:
<definitions>
  <definition term="max_token_length">
    The maximum token length. If a token is seen that exceeds this length then it is split at `max_token_length` intervals. Defaults to `255`.
  </definition>
</definitions>