﻿---
title: Whitespace analyzer
description: The whitespace analyzer breaks text into terms whenever it encounters a whitespace character. The above sentence would produce the following terms: The...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-whitespace-analyzer
products:
  - Elasticsearch
---

# Whitespace analyzer
The `whitespace` analyzer breaks text into terms whenever it encounters a whitespace character.

## Example output

```json

{
  "analyzer": "whitespace",
  "text": "The 2 QUICK Brown-Foxes jumped over the lazy dog's bone."
}
```

The above sentence would produce the following terms:
```text
[ The, 2, QUICK, Brown-Foxes, jumped, over, the, lazy, dog's, bone. ]
```


## Configuration

The `whitespace` analyzer is not configurable.

## Definition

It consists of:
<definitions>
  <definition term="Tokenizer">
    - [Whitespace Tokenizer](https://www.elastic.co/docs/reference/text-analysis/analysis-whitespace-tokenizer)
  </definition>
</definitions>

If you need to customize the `whitespace` analyzer then you need to recreate it as a `custom` analyzer and modify it, usually by adding token filters. This would recreate the built-in `whitespace` analyzer and you can use it as a starting point for further customization:
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "rebuilt_whitespace": {
          "tokenizer": "whitespace",
          "filter": [         <1>
          ]
        }
      }
    }
  }
}
```