﻿---
title: Uppercase token filter
description: Changes token text to uppercase. For example, you can use the uppercase filter to change the Lazy DoG to THE LAZY DOG. This filter uses Lucene’s UpperCaseFilter...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-uppercase-tokenfilter
products:
  - Elasticsearch
---

# Uppercase token filter
Changes token text to uppercase. For example, you can use the `uppercase` filter to change `the Lazy DoG` to `THE LAZY DOG`.
This filter uses Lucene’s [UpperCaseFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/core/UpperCaseFilter.md).
<warning>
  Depending on the language, an uppercase character can map to multiple lowercase characters. Using the `uppercase` filter could result in the loss of lowercase character information.To avoid this loss but still have a consistent letter case, use the [`lowercase`](https://www.elastic.co/docs/reference/text-analysis/analysis-lowercase-tokenfilter) filter instead.
</warning>


## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request uses the default `uppercase` filter to change the `the Quick FoX JUMPs` to uppercase:
```json

{
  "tokenizer" : "standard",
  "filter" : ["uppercase"],
  "text" : "the Quick FoX JUMPs"
}
```

The filter produces the following tokens:
```text
[ THE, QUICK, FOX, JUMPS ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the `uppercase` filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "whitespace_uppercase": {
          "tokenizer": "whitespace",
          "filter": [ "uppercase" ]
        }
      }
    }
  }
}
```