﻿---
title: UAX URL email tokenizer
description: The uax_url_email tokenizer is like the standard tokenizer except that it recognises URLs and email addresses as single tokens. The above sentence would...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-uaxurlemail-tokenizer
products:
  - Elasticsearch
---

# UAX URL email tokenizer
The `uax_url_email` tokenizer is like the [`standard` tokenizer](https://www.elastic.co/docs/reference/text-analysis/analysis-standard-tokenizer) except that it recognises URLs and email addresses as single tokens.

## Example output

```json

{
  "tokenizer": "uax_url_email",
  "text": "Email me at john.smith@global-international.com"
}
```

The above sentence would produce the following terms:
```text
[ Email, me, at, john.smith@global-international.com ]
```

while the `standard` tokenizer would produce:
```text
[ Email, me, at, john.smith, global, international.com ]
```


## Configuration

The `uax_url_email` tokenizer accepts the following parameters:
<definitions>
  <definition term="max_token_length">
    The maximum token length. If a token is seen that exceeds this length then it is split at `max_token_length` intervals. Defaults to `255`.
  </definition>
</definitions>


## Example configuration

In this example, we configure the `uax_url_email` tokenizer to have a `max_token_length` of 5 (for demonstration purposes):
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_analyzer": {
          "tokenizer": "my_tokenizer"
        }
      },
      "tokenizer": {
        "my_tokenizer": {
          "type": "uax_url_email",
          "max_token_length": 5
        }
      }
    }
  }
}


{
  "analyzer": "my_analyzer",
  "text": "john.smith@global-international.com"
}
```

The above example produces the following terms:
```text
[ john, smith, globa, l, inter, natio, nal.c, om ]
```