﻿---
title: Stop analyzer
description: The stop analyzer is the same as the simple analyzer but adds support for removing stop words. It defaults to using the _english_ stop words. The above...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-stop-analyzer
products:
  - Elasticsearch
---

# Stop analyzer
The `stop` analyzer is the same as the [`simple` analyzer](https://www.elastic.co/docs/reference/text-analysis/analysis-simple-analyzer) but adds support for removing stop words. It defaults to using the `_english_` stop words.

## Example output

```json

{
  "analyzer": "stop",
  "text": "The 2 QUICK Brown-Foxes jumped over the lazy dog's bone."
}
```

The above sentence would produce the following terms:
```text
[ quick, brown, foxes, jumped, over, lazy, dog, s, bone ]
```


## Configuration

The `stop` analyzer accepts the following parameters:
<definitions>
  <definition term="stopwords">
    A pre-defined stop words list like `_english_` or an array containing a list of stop words. Defaults to `_english_`.
  </definition>
  <definition term="stopwords_path">
    The path to a file containing stop words. This path is relative to the Elasticsearch `config` directory.
  </definition>
</definitions>

See the [Stop Token Filter](https://www.elastic.co/docs/reference/text-analysis/analysis-stop-tokenfilter) for more information about stop word configuration.

## Example configuration

In this example, we configure the `stop` analyzer to use a specified list of words as stop words:
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_stop_analyzer": {
          "type": "stop",
          "stopwords": ["the", "over"]
        }
      }
    }
  }
}


{
  "analyzer": "my_stop_analyzer",
  "text": "The 2 QUICK Brown-Foxes jumped over the lazy dog's bone."
}
```

The above example produces the following terms:
```text
[ quick, brown, foxes, jumped, lazy, dog, s, bone ]
```


## Definition

It consists of:
<definitions>
  <definition term="Tokenizer">
    - [Lower Case Tokenizer](https://www.elastic.co/docs/reference/text-analysis/analysis-lowercase-tokenizer)
  </definition>
  <definition term="Token filters">
    - [Stop Token Filter](https://www.elastic.co/docs/reference/text-analysis/analysis-stop-tokenfilter)
  </definition>
</definitions>

If you need to customize the `stop` analyzer beyond the configuration parameters then you need to recreate it as a `custom` analyzer and modify it, usually by adding token filters. This would recreate the built-in `stop` analyzer and you can use it as a starting point for further customization:
```json

{
  "settings": {
    "analysis": {
      "filter": {
        "english_stop": {
          "type":       "stop",
          "stopwords":  "_english_" <1>
        }
      },
      "analyzer": {
        "rebuilt_stop": {
          "tokenizer": "lowercase",
          "filter": [
            "english_stop"          <2>
          ]
        }
      }
    }
  }
}
```