﻿---
title: Standard analyzer
description: The standard analyzer is the default analyzer which is used if none is specified. It provides grammar based tokenization (based on the Unicode Text Segmentation...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-standard-analyzer
products:
  - Elasticsearch
---

# Standard analyzer
The `standard` analyzer is the default analyzer which is used if none is specified. It provides grammar based tokenization (based on the Unicode Text Segmentation algorithm, as specified in [Unicode Standard Annex #29](https://unicode.org/reports/tr29/)) and works well for most languages.

## Example output

```json

{
  "analyzer": "standard",
  "text": "The 2 QUICK Brown-Foxes jumped over the lazy dog's bone."
}
```

The above sentence would produce the following terms:
```text
[ the, 2, quick, brown, foxes, jumped, over, the, lazy, dog's, bone ]
```


## Configuration

The `standard` analyzer accepts the following parameters:
<definitions>
  <definition term="max_token_length">
    The maximum token length. If a token is seen that exceeds this length then it is split at `max_token_length` intervals. Defaults to `255`.
  </definition>
  <definition term="stopwords">
    A pre-defined stop words list like `_english_` or an array containing a list of stop words. Defaults to `_none_`.
  </definition>
  <definition term="stopwords_path">
    The path to a file containing stop words.
  </definition>
</definitions>

See the [Stop Token Filter](https://www.elastic.co/docs/reference/text-analysis/analysis-stop-tokenfilter) for more information about stop word configuration.

## Example configuration

In this example, we configure the `standard` analyzer to have a `max_token_length` of 5 (for demonstration purposes), and to use the pre-defined list of English stop words:
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_english_analyzer": {
          "type": "standard",
          "max_token_length": 5,
          "stopwords": "_english_"
        }
      }
    }
  }
}


{
  "analyzer": "my_english_analyzer",
  "text": "The 2 QUICK Brown-Foxes jumped over the lazy dog's bone."
}
```

The above example produces the following terms:
```text
[ 2, quick, brown, foxes, jumpe, d, over, lazy, dog's, bone ]
```


## Definition

The `standard` analyzer consists of:
<definitions>
  <definition term="Tokenizer">
    - [Standard Tokenizer](https://www.elastic.co/docs/reference/text-analysis/analysis-standard-tokenizer)
  </definition>
  <definition term="Token Filters">
    - [Lower Case Token Filter](https://www.elastic.co/docs/reference/text-analysis/analysis-lowercase-tokenfilter)
    - [Stop Token Filter](https://www.elastic.co/docs/reference/text-analysis/analysis-stop-tokenfilter) (disabled by default)
  </definition>
</definitions>

If you need to customize the `standard` analyzer beyond the configuration parameters then you need to recreate it as a `custom` analyzer and modify it, usually by adding token filters. This would recreate the built-in `standard` analyzer and you can use it as a starting point:
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "rebuilt_standard": {
          "tokenizer": "standard",
          "filter": [
            "lowercase"       <1>
          ]
        }
      }
    }
  }
}
```