﻿---
title: Simple pattern split tokenizer
description: The simple_pattern_split tokenizer uses a regular expression to split the input into terms at pattern matches. The set of regular expression features...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-simplepatternsplit-tokenizer
products:
  - Elasticsearch
---

# Simple pattern split tokenizer
The `simple_pattern_split` tokenizer uses a regular expression to split the input into terms at pattern matches. The set of regular expression features it supports is more limited than the [`pattern`](https://www.elastic.co/docs/reference/text-analysis/analysis-pattern-tokenizer) tokenizer, but the tokenization is generally faster.
This tokenizer does not produce terms from the matches themselves. To produce terms from matches using patterns in the same restricted regular expression subset, see the [`simple_pattern`](https://www.elastic.co/docs/reference/text-analysis/analysis-simplepattern-tokenizer) tokenizer.
This tokenizer uses [Lucene regular expressions](https://lucene.apache.org/core/10_0_0/core/org/apache/lucene/util/automaton/RegExp.html). For an explanation of the supported features and syntax, see [Regular Expression Syntax](https://www.elastic.co/docs/reference/query-languages/query-dsl/regexp-syntax).
The default pattern is the empty string, which produces one term containing the full input. This tokenizer should always be configured with a non-default pattern.

## Configuration

The `simple_pattern_split` tokenizer accepts the following parameters:
<definitions>
  <definition term="pattern">
    A [Lucene regular expression](https://lucene.apache.org/core/10_0_0/core/org/apache/lucene/util/automaton/RegExp.html), defaults to the empty string.
  </definition>
</definitions>


## Example configuration

This example configures the `simple_pattern_split` tokenizer to split the input text on underscores.
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_analyzer": {
          "tokenizer": "my_tokenizer"
        }
      },
      "tokenizer": {
        "my_tokenizer": {
          "type": "simple_pattern_split",
          "pattern": "_"
        }
      }
    }
  }
}


{
  "analyzer": "my_analyzer",
  "text": "an_underscored_phrase"
}
```

The above example produces these terms:
```text
[ an, underscored, phrase ]
```