﻿---
title: Simple analyzer
description: The simple analyzer breaks text into tokens at any non-letter character, such as numbers, spaces, hyphens and apostrophes, discards non-letter characters,...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-simple-analyzer
products:
  - Elasticsearch
---

# Simple analyzer
The `simple` analyzer breaks text into tokens at any non-letter character, such as numbers, spaces, hyphens and apostrophes, discards non-letter characters, and changes uppercase to lowercase.

## Example

```json

{
  "analyzer": "simple",
  "text": "The 2 QUICK Brown-Foxes jumped over the lazy dog's bone."
}
```

The `simple` analyzer parses the sentence and produces the following tokens:
```text
[ the, quick, brown, foxes, jumped, over, the, lazy, dog, s, bone ]
```


## Definition

The `simple` analyzer is defined by one tokenizer:
<definitions>
  <definition term="Tokenizer">
    - [Lowercase Tokenizer](https://www.elastic.co/docs/reference/text-analysis/analysis-lowercase-tokenizer)
  </definition>
</definitions>


## Customize

To customize the `simple` analyzer, duplicate it to create the basis for a custom analyzer. This custom analyzer can be modified as required, usually by adding token filters.
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_custom_simple_analyzer": {
          "tokenizer": "lowercase",
          "filter": [                          <1>
          ]
        }
      }
    }
  }
}
```