﻿---
title: Reverse token filter
description: Reverses each token in a stream. For example, you can use the reverse filter to change cat to tac. Reversed tokens are useful for suffix-based searches,...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-reverse-tokenfilter
products:
  - Elasticsearch
---

# Reverse token filter
Reverses each token in a stream. For example, you can use the `reverse` filter to change `cat` to `tac`.
Reversed tokens are useful for suffix-based searches, such as finding words that end in `-ion` or searching file names by their extension.
This filter uses Lucene’s [ReverseStringFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/reverse/ReverseStringFilter.html).

## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request uses the `reverse` filter to reverse each token in `quick fox jumps`:
```json

{
  "tokenizer" : "standard",
  "filter" : ["reverse"],
  "text" : "quick fox jumps"
}
```

The filter produces the following tokens:
```text
[ kciuq, xof, spmuj ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the `reverse` filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
```json

{
  "settings" : {
    "analysis" : {
      "analyzer" : {
        "whitespace_reverse" : {
          "tokenizer" : "whitespace",
          "filter" : ["reverse"]
        }
      }
    }
  }
}
```