﻿---
title: Predicate script token filter
description: Removes tokens that don’t match a provided predicate script. The filter supports inline Painless scripts only. Scripts are evaluated in the analysis predicate...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-predicatefilter-tokenfilter
products:
  - Elasticsearch
---

# Predicate script token filter
Removes tokens that don’t match a provided predicate script. The filter supports inline [Painless](https://www.elastic.co/docs/reference/scripting-languages/painless/painless) scripts only. Scripts are evaluated in the [analysis predicate context](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-analysis-predicate-context).

## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request uses the `predicate_token_filter` filter to only output tokens longer than three characters from `the fox jumps the lazy dog`.
```json

{
  "tokenizer": "whitespace",
  "filter": [
    {
      "type": "predicate_token_filter",
      "script": {
        "source": """
          token.term.length() > 3
        """
      }
    }
  ],
  "text": "the fox jumps the lazy dog"
}
```

The filter produces the following tokens.
```text
[ jumps, lazy ]
```

The API response contains the position and offsets of each output token. Note the `predicate_token_filter` filter does not change the tokens' original positions or offsets.
<dropdown title="Response">
  ```json
  {
    "tokens" : [
      {
        "token" : "jumps",
        "start_offset" : 8,
        "end_offset" : 13,
        "type" : "word",
        "position" : 2
      },
      {
        "token" : "lazy",
        "start_offset" : 18,
        "end_offset" : 22,
        "type" : "word",
        "position" : 4
      }
    ]
  }
  ```
</dropdown>


## Configurable parameters

<definitions>
  <definition term="script">
    (Required, [script object](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-using)) Script containing a condition used to filter incoming tokens. Only tokens that match this script are included in the output.
    This parameter supports inline [Painless](https://www.elastic.co/docs/reference/scripting-languages/painless/painless) scripts only. The script is evaluated in the [analysis predicate context](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-analysis-predicate-context).
  </definition>
</definitions>


## Customize and add to an analyzer

To customize the `predicate_token_filter` filter, duplicate it to create the basis for a new custom token filter. You can modify the filter using its configurable parameters.
The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request configures a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer) using a custom `predicate_token_filter` filter, `my_script_filter`.
The `my_script_filter` filter removes tokens with of any type other than `ALPHANUM`.
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_analyzer": {
          "tokenizer": "standard",
          "filter": [
            "my_script_filter"
          ]
        }
      },
      "filter": {
        "my_script_filter": {
          "type": "predicate_token_filter",
          "script": {
            "source": """
              token.type.contains("ALPHANUM")
            """
          }
        }
      }
    }
  }
}
```