﻿---
title: Porter stem token filter
description: Provides algorithmic stemming for the English language, based on the Porter stemming algorithm. This filter tends to stem more aggressively than other...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-porterstem-tokenfilter
products:
  - Elasticsearch
---

# Porter stem token filter
Provides [algorithmic stemming](https://www.elastic.co/docs/manage-data/data-store/text-analysis/stemming#algorithmic-stemmers) for the English language, based on the [Porter stemming algorithm](https://snowballstem.org/algorithms/porter/stemmer.html).
This filter tends to stem more aggressively than other English stemmer filters, such as the [`kstem`](https://www.elastic.co/docs/reference/text-analysis/analysis-kstem-tokenfilter) filter.
The `porter_stem` filter is equivalent to the [`stemmer`](https://www.elastic.co/docs/reference/text-analysis/analysis-stemmer-tokenfilter) filter’s [`english`](/docs/reference/text-analysis/analysis-stemmer-tokenfilter#analysis-stemmer-tokenfilter-language-parm) variant.
The `porter_stem` filter uses Lucene’s [PorterStemFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/en/PorterStemFilter.html).

## Example

The following analyze API request uses the `porter_stem` filter to stem `the foxes jumping quickly` to `the fox jump quickli`:
```json

{
  "tokenizer": "standard",
  "filter": [ "porter_stem" ],
  "text": "the foxes jumping quickly"
}
```

The filter produces the following tokens:
```text
[ the, fox, jump, quickli ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the `porter_stem` filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
<important>
  To work properly, the `porter_stem` filter requires lowercase tokens. To ensure tokens are lowercased, add the [`lowercase`](https://www.elastic.co/docs/reference/text-analysis/analysis-lowercase-tokenfilter) filter before the `porter_stem` filter in the analyzer configuration.
</important>

```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_analyzer": {
          "tokenizer": "whitespace",
          "filter": [
            "lowercase",
            "porter_stem"
          ]
        }
      }
    }
  }
}
```