﻿---
title: Normalization token filters
description: There are several token filters available which try to normalize special characters of a certain language. 
url: https://www.elastic.co/docs/reference/text-analysis/analysis-normalization-tokenfilter
products:
  - Elasticsearch
---

# Normalization token filters
There are several token filters available which try to normalize special characters of a certain language.
<definitions>
  <definition term="Arabic">
    [`arabic_normalization`](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/ar/ArabicNormalizationFilter.html)
  </definition>
  <definition term="German">
    [`german_normalization`](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/de/GermanNormalizationFilter.html)
  </definition>
  <definition term="Hindi">
    [`hindi_normalization`](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/hi/HindiNormalizationFilter.html)
  </definition>
  <definition term="Indic">
    [`indic_normalization`](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/in/IndicNormalizationFilter.html)
  </definition>
  <definition term="Kurdish (Sorani)">
    [`sorani_normalization`](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/ckb/SoraniNormalizationFilter.html)
  </definition>
  <definition term="Persian">
    [`persian_normalization`](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/fa/PersianNormalizationFilter.html)
  </definition>
  <definition term="Scandinavian">
    [`scandinavian_normalization`](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/miscellaneous/ScandinavianNormalizer.html), [`scandinavian_folding`](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/miscellaneous/ScandinavianFoldingFilter.html)
  </definition>
  <definition term="Serbian">
    [`serbian_normalization`](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/sr/SerbianNormalizationFilter.html)
  </definition>
</definitions>