﻿---
title: N-gram token filter
description: Forms n-grams of specified lengths from a token. For example, you can use the ngram token filter to change fox to [ f, fo, o, ox, x ]. This filter uses...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-ngram-tokenfilter
products:
  - Elasticsearch
---

# N-gram token filter
Forms [n-grams](https://en.wikipedia.org/wiki/N-gram) of specified lengths from a token.
For example, you can use the `ngram` token filter to change `fox` to `[ f, fo, o, ox, x ]`.
This filter uses Lucene’s [NGramTokenFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/ngram/NGramTokenFilter.md).
<note>
  The `ngram` filter is similar to the [`edge_ngram` token filter](https://www.elastic.co/docs/reference/text-analysis/analysis-edgengram-tokenfilter). However, the `edge_ngram` only outputs n-grams that start at the beginning of a token.
</note>


## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request uses the `ngram` filter to convert `Quick fox` to 1-character and 2-character n-grams:
```json

{
  "tokenizer": "standard",
  "filter": [ "ngram" ],
  "text": "Quick fox"
}
```

The filter produces the following tokens:
```text
[ Q, Qu, u, ui, i, ic, c, ck, k, f, fo, o, ox, x ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the `ngram` filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "standard_ngram": {
          "tokenizer": "standard",
          "filter": [ "ngram" ]
        }
      }
    }
  }
}
```


## Configurable parameters

<definitions>
  <definition term="max_gram">
    (Optional, integer) Maximum length of characters in a gram. Defaults to `2`.
  </definition>
  <definition term="min_gram">
    (Optional, integer) Minimum length of characters in a gram. Defaults to `1`.
  </definition>
  <definition term="preserve_original">
    (Optional, Boolean) Emits original token when set to `true`. Defaults to `false`.
  </definition>
</definitions>

You can use the [`index.max_ngram_diff`](/docs/reference/elasticsearch/index-settings/index-modules#index-max-ngram-diff) index-level setting to control the maximum allowed difference between the `max_gram` and `min_gram` values.

## Customize

To customize the `ngram` filter, duplicate it to create the basis for a new custom token filter. You can modify the filter using its configurable parameters.
For example, the following request creates a custom `ngram` filter that forms n-grams between 3-5 characters. The request also increases the `index.max_ngram_diff` setting to `2`.
```json

{
  "settings": {
    "index": {
      "max_ngram_diff": 2
    },
    "analysis": {
      "analyzer": {
        "default": {
          "tokenizer": "whitespace",
          "filter": [ "3_5_grams" ]
        }
      },
      "filter": {
        "3_5_grams": {
          "type": "ngram",
          "min_gram": 3,
          "max_gram": 5
        }
      }
    }
  }
}
```