﻿---
title: Lowercase tokenizer
description: The lowercase tokenizer, like the letter tokenizer breaks text into terms whenever it encounters a character which is not a letter, but it also lowercases...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-lowercase-tokenizer
products:
  - Elasticsearch
---

# Lowercase tokenizer
The `lowercase` tokenizer, like the [`letter` tokenizer](https://www.elastic.co/docs/reference/text-analysis/analysis-letter-tokenizer) breaks text into terms whenever it encounters a character which is not a letter, but it also lowercases all terms. It is functionally equivalent to the [`letter` tokenizer](https://www.elastic.co/docs/reference/text-analysis/analysis-letter-tokenizer) combined with the [`lowercase` token filter](https://www.elastic.co/docs/reference/text-analysis/analysis-lowercase-tokenfilter), but is more efficient as it performs both steps in a single pass.

## Example output

```json

{
  "tokenizer": "lowercase",
  "text": "The 2 QUICK Brown-Foxes jumped over the lazy dog's bone."
}
```

The above sentence would produce the following terms:
```text
[ the, quick, brown, foxes, jumped, over, the, lazy, dog, s, bone ]
```


## Configuration

The `lowercase` tokenizer is not configurable.