﻿---
title: Lowercase token filter
description: Changes token text to lowercase. For example, you can use the lowercase filter to change THE Lazy DoG to the lazy dog. In addition to a default filter,...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-lowercase-tokenfilter
products:
  - Elasticsearch
---

# Lowercase token filter
Changes token text to lowercase. For example, you can use the `lowercase` filter to change `THE Lazy DoG` to `the lazy dog`.
In addition to a default filter, the `lowercase` token filter provides access to Lucene’s language-specific lowercase filters for Greek, Irish, and Turkish.

## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request uses the default `lowercase` filter to change the `THE Quick FoX JUMPs` to lowercase:
```json

{
  "tokenizer" : "standard",
  "filter" : ["lowercase"],
  "text" : "THE Quick FoX JUMPs"
}
```

The filter produces the following tokens:
```text
[ the, quick, fox, jumps ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the `lowercase` filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "whitespace_lowercase": {
          "tokenizer": "whitespace",
          "filter": [ "lowercase" ]
        }
      }
    }
  }
}
```


## Configurable parameters

<definitions>
  <definition term="language">
    (Optional, string) Language-specific lowercase token filter to use. Valid values include:
  </definition>
  <definition term="greek">
    Uses Lucene’s [GreekLowerCaseFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/el/GreekLowerCaseFilter.html)
  </definition>
  <definition term="irish">
    Uses Lucene’s [IrishLowerCaseFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/ga/IrishLowerCaseFilter.html)
  </definition>
  <definition term="turkish">
    Uses Lucene’s [TurkishLowerCaseFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/tr/TurkishLowerCaseFilter.html)
  </definition>
</definitions>

If not specified, defaults to Lucene’s [LowerCaseFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/core/LowerCaseFilter.html).

## Customize

To customize the `lowercase` filter, duplicate it to create the basis for a new custom token filter. You can modify the filter using its configurable parameters.
For example, the following request creates a custom `lowercase` filter for the Greek language:
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "greek_lowercase_example": {
          "type": "custom",
          "tokenizer": "standard",
          "filter": ["greek_lowercase"]
        }
      },
      "filter": {
        "greek_lowercase": {
          "type": "lowercase",
          "language": "greek"
        }
      }
    }
  }
}
```