﻿---
title: KStem token filter
description: Provides KStem-based stemming for the English language. The kstem filter combines algorithmic stemming with a built-in dictionary. The kstem filter tends...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-kstem-tokenfilter
products:
  - Elasticsearch
---

# KStem token filter
Provides [KStem](https://ciir.cs.umass.edu/pubfiles/ir-35.pdf)-based stemming for the English language. The `kstem` filter combines [algorithmic stemming](https://www.elastic.co/docs/manage-data/data-store/text-analysis/stemming#algorithmic-stemmers) with a built-in [dictionary](https://www.elastic.co/docs/manage-data/data-store/text-analysis/stemming#dictionary-stemmers).
The `kstem` filter tends to stem less aggressively than other English stemmer filters, such as the [`porter_stem`](https://www.elastic.co/docs/reference/text-analysis/analysis-porterstem-tokenfilter) filter.
The `kstem` filter is equivalent to the [`stemmer`](https://www.elastic.co/docs/reference/text-analysis/analysis-stemmer-tokenfilter) filter’s [`light_english`](/docs/reference/text-analysis/analysis-stemmer-tokenfilter#analysis-stemmer-tokenfilter-language-parm) variant.
This filter uses Lucene’s [KStemFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/en/KStemFilter.md).

## Example

The following analyze API request uses the `kstem` filter to stem `the foxes jumping quickly` to `the fox jump quick`:
```json

{
  "tokenizer": "standard",
  "filter": [ "kstem" ],
  "text": "the foxes jumping quickly"
}
```

The filter produces the following tokens:
```text
[ the, fox, jump, quick ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the `kstem` filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
<important>
  To work properly, the `kstem` filter requires lowercase tokens. To ensure tokens are lowercased, add the [`lowercase`](https://www.elastic.co/docs/reference/text-analysis/analysis-lowercase-tokenfilter) filter before the `kstem` filter in the analyzer configuration.
</important>

```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_analyzer": {
          "tokenizer": "whitespace",
          "filter": [
            "lowercase",
            "kstem"
          ]
        }
      }
    }
  }
}
```