﻿---
title: Keyword analyzer
description: The keyword analyzer is a noop analyzer which returns the entire input string as a single token. The above sentence would produce the following single...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-keyword-analyzer
products:
  - Elasticsearch
---

# Keyword analyzer
The `keyword` analyzer is a noop analyzer which returns the entire input string as a single token.

## Example output

```json

{
  "analyzer": "keyword",
  "text": "The 2 QUICK Brown-Foxes jumped over the lazy dog's bone."
}
```

The above sentence would produce the following single term:
```text
[ The 2 QUICK Brown-Foxes jumped over the lazy dog's bone. ]
```


## Configuration

The `keyword` analyzer is not configurable.

## Definition

The `keyword` analyzer consists of:
<definitions>
  <definition term="Tokenizer">
    - [Keyword Tokenizer](https://www.elastic.co/docs/reference/text-analysis/analysis-keyword-tokenizer)
  </definition>
</definitions>

If you need to customize the `keyword` analyzer then you need to recreate it as a `custom` analyzer and modify it, usually by adding token filters. Usually, you should prefer the [Keyword type](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/keyword) when you want strings that are not split into tokens, but just in case you need it, this would recreate the built-in `keyword` analyzer and you can use it as a starting point for further customization:
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "rebuilt_keyword": {
          "tokenizer": "keyword",
          "filter": [         <1>
          ]
        }
      }
    }
  }
}
```