﻿---
title: Keep words token filter
description: Keeps only tokens contained in a specified word list. This filter uses Lucene’s KeepWordFilter. The following analyze API request uses the keep filter...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-keep-words-tokenfilter
products:
  - Elasticsearch
---

# Keep words token filter
Keeps only tokens contained in a specified word list.
This filter uses Lucene’s [KeepWordFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/miscellaneous/KeepWordFilter.md).
<note>
  To remove a list of words from a token stream, use the [`stop`](https://www.elastic.co/docs/reference/text-analysis/analysis-stop-tokenfilter) filter.
</note>


## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request uses the `keep` filter to keep only the `fox` and `dog` tokens from `the quick fox jumps over the lazy dog`.
```json

{
  "tokenizer": "whitespace",
  "filter": [
    {
      "type": "keep",
      "keep_words": [ "dog", "elephant", "fox" ]
    }
  ],
  "text": "the quick fox jumps over the lazy dog"
}
```

The filter produces the following tokens:
```text
[ fox, dog ]
```


## Configurable parameters

<definitions>
  <definition term="keep_words">
    (Required*, array of strings) List of words to keep. Only tokens that match words in this list are included in the output.
  </definition>
</definitions>

Either this parameter or `keep_words_path` must be specified.
<definitions>
  <definition term="keep_words_path">
    (Required*, string) Path to a file that contains a list of words to keep. Only tokens that match words in this list are included in the output.
  </definition>
</definitions>

This path must be absolute or relative to the `config` location, and the file must be UTF-8 encoded. Each word in the file must be separated by a line break.
Either this parameter or `keep_words` must be specified.
<definitions>
  <definition term="keep_words_case">
    (Optional, Boolean) If `true`, lowercase all keep words. Defaults to `false`.
  </definition>
</definitions>


## Customize and add to an analyzer

To customize the `keep` filter, duplicate it to create the basis for a new custom token filter. You can modify the filter using its configurable parameters.
For example, the following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses custom `keep` filters to configure two new [custom analyzers](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer):
- `standard_keep_word_array`, which uses a custom `keep` filter with an inline array of keep words
- `standard_keep_word_file`, which uses a customer `keep` filter with a keep words file

```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "standard_keep_word_array": {
          "tokenizer": "standard",
          "filter": [ "keep_word_array" ]
        },
        "standard_keep_word_file": {
          "tokenizer": "standard",
          "filter": [ "keep_word_file" ]
        }
      },
      "filter": {
        "keep_word_array": {
          "type": "keep",
          "keep_words": [ "one", "two", "three" ]
        },
        "keep_word_file": {
          "type": "keep",
          "keep_words_path": "analysis/example_word_list.txt"
        }
      }
    }
  }
}
```