﻿---
title: Keep types token filter
description: Keeps or removes tokens of a specific type. For example, you can use this filter to change 3 quick foxes to quick foxes by keeping only <ALPHANUM> (alphanumeric)...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-keep-types-tokenfilter
products:
  - Elasticsearch
---

# Keep types token filter
Keeps or removes tokens of a specific type. For example, you can use this filter to change `3 quick foxes` to `quick foxes` by keeping only `<ALPHANUM>` (alphanumeric) tokens.
<admonition title="Token types">
  Token types are set by the [tokenizer](https://www.elastic.co/docs/reference/text-analysis/tokenizer-reference) when converting characters to tokens. Token types can vary between tokenizers.For example, the [`standard`](https://www.elastic.co/docs/reference/text-analysis/analysis-standard-tokenizer) tokenizer can produce a variety of token types, including `<ALPHANUM>`, `<HANGUL>`, and `<NUM>`. Simpler analyzers, like the [`lowercase`](https://www.elastic.co/docs/reference/text-analysis/analysis-lowercase-tokenizer) tokenizer, only produce the `word` token type.Certain token filters can also add token types. For example, the [`synonym`](https://www.elastic.co/docs/reference/text-analysis/analysis-synonym-tokenfilter) filter can add the `<SYNONYM>` token type.Some tokenizers don’t support this token filter, for example keyword, simple_pattern, and simple_pattern_split tokenizers, as they don’t support setting the token type attribute.
</admonition>

This filter uses Lucene’s [TypeTokenFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/core/TypeTokenFilter.md).

## Include example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request uses the `keep_types` filter to keep only `<NUM>` (numeric) tokens from `1 quick fox 2 lazy dogs`.
```json

{
  "tokenizer": "standard",
  "filter": [
    {
      "type": "keep_types",
      "types": [ "<NUM>" ]
    }
  ],
  "text": "1 quick fox 2 lazy dogs"
}
```

The filter produces the following tokens:
```text
[ 1, 2 ]
```


## Exclude example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request uses the `keep_types` filter to remove `<NUM>` tokens from `1 quick fox 2 lazy dogs`. Note the `mode` parameter is set to `exclude`.
```json

{
  "tokenizer": "standard",
  "filter": [
    {
      "type": "keep_types",
      "types": [ "<NUM>" ],
      "mode": "exclude"
    }
  ],
  "text": "1 quick fox 2 lazy dogs"
}
```

The filter produces the following tokens:
```text
[ quick, fox, lazy, dogs ]
```


## Configurable parameters

<definitions>
  <definition term="types">
    (Required, array of strings) List of token types to keep or remove.
  </definition>
  <definition term="mode">
    (Optional, string) Indicates whether to keep or remove the specified token types. Valid values are:
    <definitions>
      <definition term="include">
        (Default) Keep only the specified token types.
      </definition>
      <definition term="exclude">
        Remove the specified token types.
      </definition>
    </definitions>
  </definition>
</definitions>


## Customize and add to an analyzer

To customize the `keep_types` filter, duplicate it to create the basis for a new custom token filter. You can modify the filter using its configurable parameters.
For example, the following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses a custom `keep_types` filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer). The custom `keep_types` filter keeps only `<ALPHANUM>` (alphanumeric) tokens.
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_analyzer": {
          "tokenizer": "standard",
          "filter": [ "extract_alpha" ]
        }
      },
      "filter": {
        "extract_alpha": {
          "type": "keep_types",
          "types": [ "<ALPHANUM>" ]
        }
      }
    }
  }
}
```