﻿---
title: HTML strip character filter
description: Strips HTML elements from a text and replaces HTML entities with their decoded value (e.g, replaces &amp; with &). The html_strip filter uses Lucene’s...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-htmlstrip-charfilter
products:
  - Elasticsearch
---

# HTML strip character filter
Strips HTML elements from a text and replaces HTML entities with their decoded value (e.g, replaces `&amp;` with `&`).
The `html_strip` filter uses Lucene’s [HTMLStripCharFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/charfilter/HTMLStripCharFilter.md).

## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request uses the `html_strip` filter to change the text `<p>I&apos;m so <b>happy</b>!</p>` to `\nI'm so happy!\n`.
```json

{
  "tokenizer": "keyword",
  "char_filter": [
    "html_strip"
  ],
  "text": "<p>I&apos;m so <b>happy</b>!</p>"
}
```

The filter produces the following text:
```text
[ \nI'm so happy!\n ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the `html_strip` filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_analyzer": {
          "tokenizer": "keyword",
          "char_filter": [
            "html_strip"
          ]
        }
      }
    }
  }
}
```


## Configurable parameters

<definitions>
  <definition term="escaped_tags">
    (Optional, array of strings) Array of HTML elements without enclosing angle brackets (`< >`). The filter skips these HTML elements when stripping HTML from the text. For example, a value of `[ "p" ]` skips the `<p>` HTML element.
  </definition>
</definitions>


## Customize

To customize the `html_strip` filter, duplicate it to create the basis for a new custom character filter. You can modify the filter using its configurable parameters.
The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request configures a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer) using a custom `html_strip` filter, `my_custom_html_strip_char_filter`.
The `my_custom_html_strip_char_filter` filter skips the removal of the `<b>` HTML element.
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "my_analyzer": {
          "tokenizer": "keyword",
          "char_filter": [
            "my_custom_html_strip_char_filter"
          ]
        }
      },
      "char_filter": {
        "my_custom_html_strip_char_filter": {
          "type": "html_strip",
          "escaped_tags": [
            "b"
          ]
        }
      }
    }
  }
}
```