﻿---
title: Elision token filter
description: Removes specified elisions from the beginning of tokens. For example, you can use this filter to change l'avion to avion. When not customized, the filter...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-elision-tokenfilter
products:
  - Elasticsearch
---

# Elision token filter
Removes specified [elisions](https://en.wikipedia.org/wiki/Elision) from the beginning of tokens. For example, you can use this filter to change `l'avion` to `avion`.
When not customized, the filter removes the following French elisions by default:
`l'`, `m'`, `t'`, `qu'`, `n'`, `s'`, `j'`, `d'`, `c'`, `jusqu'`, `quoiqu'`, `lorsqu'`, `puisqu'`
Customized versions of this filter are included in several of Elasticsearch's built-in [language analyzers](https://www.elastic.co/docs/reference/text-analysis/analysis-lang-analyzer):
- [Catalan analyzer](/docs/reference/text-analysis/analysis-lang-analyzer#catalan-analyzer)
- [French analyzer](/docs/reference/text-analysis/analysis-lang-analyzer#french-analyzer)
- [Irish analyzer](/docs/reference/text-analysis/analysis-lang-analyzer#irish-analyzer)
- [Italian analyzer](/docs/reference/text-analysis/analysis-lang-analyzer#italian-analyzer)

This filter uses Lucene’s [ElisionFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/util/ElisionFilter.md).

## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request uses the `elision` filter to remove `j'` from `j’examine près du wharf`:
```json

{
  "tokenizer" : "standard",
  "filter" : ["elision"],
  "text" : "j’examine près du wharf"
}
```

The filter produces the following tokens:
```text
[ examine, près, du, wharf ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the `elision` filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "whitespace_elision": {
          "tokenizer": "whitespace",
          "filter": [ "elision" ]
        }
      }
    }
  }
}
```


## Configurable parameters


<definitions>
  <definition term="articles">
    (Required*, array of string) List of elisions to remove.
  </definition>
</definitions>

To be removed, the elision must be at the beginning of a token and be immediately followed by an apostrophe. Both the elision and apostrophe are removed.
For custom `elision` filters, either this parameter or `articles_path` must be specified.
<definitions>
  <definition term="articles_path">
    (Required*, string) Path to a file that contains a list of elisions to remove.
  </definition>
</definitions>

This path must be absolute or relative to the `config` location, and the file must be UTF-8 encoded. Each elision in the file must be separated by a line break.
To be removed, the elision must be at the beginning of a token and be immediately followed by an apostrophe. Both the elision and apostrophe are removed.
For custom `elision` filters, either this parameter or `articles` must be specified.
<definitions>
  <definition term="articles_case">
    (Optional, Boolean) If `true`, elision matching is case insensitive. If `false`, elision matching is case sensitive. Defaults to `false`.
  </definition>
</definitions>


## Customize

To customize the `elision` filter, duplicate it to create the basis for a new custom token filter. You can modify the filter using its configurable parameters.
For example, the following request creates a custom case-insensitive `elision` filter that removes the `l'`, `m'`, `t'`, `qu'`, `n'`, `s'`, and `j'` elisions:
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "default": {
          "tokenizer": "whitespace",
          "filter": [ "elision_case_insensitive" ]
        }
      },
      "filter": {
        "elision_case_insensitive": {
          "type": "elision",
          "articles": [ "l", "m", "t", "qu", "n", "s", "j" ],
          "articles_case": true
        }
      }
    }
  }
}
```