﻿---
title: Classic token filter
description: Performs optional post-processing of terms generated by the classic tokenizer. This filter removes the english possessive ('s) from the end of words and...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-classic-tokenfilter
products:
  - Elasticsearch
---

# Classic token filter
Performs optional post-processing of terms generated by the [`classic` tokenizer](https://www.elastic.co/docs/reference/text-analysis/analysis-classic-tokenizer).
This filter removes the english possessive (`'s`) from the end of words and removes dots from acronyms. It uses Lucene’s [ClassicFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/standard/ClassicFilter.md).

## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request demonstrates how the classic token filter works.
```json

{
  "tokenizer" : "classic",
  "filter" : ["classic"],
  "text" : "The 2 Q.U.I.C.K. Brown-Foxes jumped over the lazy dog's bone."
}
```

The filter produces the following tokens:
```text
[ The, 2, QUICK, Brown, Foxes, jumped, over, the, lazy, dog, bone ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the classic token filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "classic_analyzer": {
          "tokenizer": "classic",
          "filter": [ "classic" ]
        }
      }
    }
  }
}
```