﻿---
title: CJK bigram token filter
description: Forms bigrams out of CJK (Chinese, Japanese, and Korean) tokens. This filter is included in Elasticsearch's built-in CJK language analyzer. It uses Lucene’s...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-cjk-bigram-tokenfilter
products:
  - Elasticsearch
---

# CJK bigram token filter
Forms [bigrams](https://en.wikipedia.org/wiki/Bigram) out of CJK (Chinese, Japanese, and Korean) tokens.
This filter is included in Elasticsearch's built-in [CJK language analyzer](/docs/reference/text-analysis/analysis-lang-analyzer#cjk-analyzer). It uses Lucene’s [CJKBigramFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/cjk/CJKBigramFilter.md).

## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request demonstrates how the CJK bigram token filter works.
```json

{
  "tokenizer" : "standard",
  "filter" : ["cjk_bigram"],
  "text" : "東京都は、日本の首都であり"
}
```

The filter produces the following tokens:
```text
[ 東京, 京都, 都は, 日本, 本の, の首, 首都, 都で, であ, あり ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the CJK bigram token filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "standard_cjk_bigram": {
          "tokenizer": "standard",
          "filter": [ "cjk_bigram" ]
        }
      }
    }
  }
}
```


## Configurable parameters

<definitions>
  <definition term="ignored_scripts">
    (Optional, array of character scripts) Array of character scripts for which to disable bigrams. Possible values:
  </definition>
</definitions>

- `han`
- `hangul`
- `hiragana`
- `katakana`

All non-CJK input is passed through unmodified.
<definitions>
  <definition term="output_unigrams">
    (Optional, Boolean) If `true`, emit tokens in both bigram and [unigram](https://en.wikipedia.org/wiki/N-gram) form. If `false`, a CJK character is output in unigram form when it has no adjacent characters. Defaults to `false`.
  </definition>
</definitions>


## Customize

To customize the CJK bigram token filter, duplicate it to create the basis for a new custom token filter. You can modify the filter using its configurable parameters.
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "han_bigrams": {
          "tokenizer": "standard",
          "filter": [ "han_bigrams_filter" ]
        }
      },
      "filter": {
        "han_bigrams_filter": {
          "type": "cjk_bigram",
          "ignored_scripts": [
            "hangul",
            "hiragana",
            "katakana"
          ],
          "output_unigrams": true
        }
      }
    }
  }
}
```