﻿---
title: Apostrophe token filter
description: Strips all characters after an apostrophe, including the apostrophe itself. This filter is included in Elasticsearch's built-in Turkish language analyzer...
url: https://www.elastic.co/docs/reference/text-analysis/analysis-apostrophe-tokenfilter
products:
  - Elasticsearch
---

# Apostrophe token filter
Strips all characters after an apostrophe, including the apostrophe itself.
This filter is included in Elasticsearch's built-in [Turkish language analyzer](/docs/reference/text-analysis/analysis-lang-analyzer#turkish-analyzer). It uses Lucene’s [ApostropheFilter](https://lucene.apache.org/core/10_0_0/analysis/common/org/apache/lucene/analysis/tr/ApostropheFilter.html), which was built for the Turkish language.

## Example

The following [analyze API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-analyze) request demonstrates how the apostrophe token filter works.
```json

{
  "tokenizer" : "standard",
  "filter" : ["apostrophe"],
  "text" : "Istanbul'a veya Istanbul'dan"
}
```

The filter produces the following tokens:
```text
[ Istanbul, veya, Istanbul ]
```


## Add to an analyzer

The following [create index API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) request uses the apostrophe token filter to configure a new [custom analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/create-custom-analyzer).
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "standard_apostrophe": {
          "tokenizer": "standard",
          "filter": [ "apostrophe" ]
        }
      }
    }
  }
}
```