﻿---
title: AWS STS GetSessionToken Usage
description: Identifies the use of GetSessionToken API calls by IAM users or Root Account. While this is a common and legitimate operation used to obtain temporary...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/privilege_escalation_sts_getsessiontoken_abuse
products:
  - Elastic Security
---

# AWS STS GetSessionToken Usage
Identifies the use of GetSessionToken API calls by IAM users or Root Account. While this is a common and legitimate
operation used to obtain temporary credentials, it also provides adversaries with a method to generate short-lived
tokens for stealthy activity. Attackers who compromise IAM user access keys may call GetSessionToken to create temporary
credentials, which they can then use to move laterally, escalate privileges, or persist after key rotation. This rule is
intended as a BBR to establish patterns of typical STS usage and support correlation with higher-fidelity detections.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://docs.aws.amazon.com/STS/latest/APIReference/API_GetSessionToken.html](https://docs.aws.amazon.com/STS/latest/APIReference/API_GetSessionToken.html)](https://docs.aws.amazon.com/STS/latest/APIReference/API_GetSessionToken.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS STS
- Use Case: Identity and Access Audit
- Tactic: Privilege Escalation
- Tactic: Lateral Movement
- Resources: Investigation Guide
- Rule Type: BBR

**Version**: 210
**Rule authors**:
- Austin Songer
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating AWS STS GetSessionToken Usage

AWS Security Token Service (STS) provides temporary credentials for AWS resources, crucial for managing access without long-term credentials. Adversaries may exploit `GetSessionToken` to create temporary credentials, enabling lateral movement and privilege escalation. The detection rule identifies successful `GetSessionToken` requests, flagging potential misuse for further investigation.

#### Possible investigation steps

- **Establish normal baseline behavior**
  - Use this rule’s data to determine which IAM users or automation scripts routinely perform `GetSessionToken`.
- Monitor frequency, regions, and user agents (CLI, SDK, console) for each identity over time.
- **Identify anomalies**
  - Look for first-time or rare `GetSessionToken` usage by an IAM user.
- Detect tokens issued without MFA when MFA is normally required.
- Identify new or unexpected source IPs, geographies, or user agents (e.g., API calls from unfamiliar networks).
- Check for multiple temporary tokens minted in rapid succession by the same user or access key.
- **Correlate with downstream activity**
  - Search for immediate follow-on events within 15 minutes of token creation:
  - `AssumeRole` into higher-privileged roles or cross-account roles.
- Privileged API calls (e.g., `iam:*`, `s3:PutBucketPolicy`, `ec2:CreateSnapshot`).
- New region access, resource enumeration, or credential operations (`GetCallerIdentity`, `ListUsers`, etc.).
- Use this correlation to elevate contextual `GetSessionToken` behavior into actionable detections.


### Usage Notes

- This rule’s telemetry can support hunting queries such as:
  - `GetSessionToken` without `TokenCode` (no MFA)
- New IP + `GetSessionToken` + `AssumeRole`
- Rapid token issuance followed by API activity from a new ASN

Use these patterns in combination with related BBRs or detection rules for `AssumeRole` abuse, cross-account access,
or credential pivoting for more reliable threat detection.

## Rule Query

```kuery
event.dataset: aws.cloudtrail 
  and event.provider: sts.amazonaws.com 
  and event.action: GetSessionToken 
  and event.outcome: success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Abuse Elevation Control Mechanism
- Id: T1548
- Reference URL: [[https://attack.mitre.org/techniques/T1548/](https://attack.mitre.org/techniques/T1548/)](https://attack.mitre.org/techniques/T1548/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Use Alternate Authentication Material
- Id: T1550
- Reference URL: [[https://attack.mitre.org/techniques/T1550/](https://attack.mitre.org/techniques/T1550/)](https://attack.mitre.org/techniques/T1550/)
- Sub Technique:
  - Name: Application Access Token
- Id: T1550.001
- Reference URL: [[https://attack.mitre.org/techniques/T1550/001/](https://attack.mitre.org/techniques/T1550/001/)](https://attack.mitre.org/techniques/T1550/001/)