﻿---
title: Web Server Potential SQL Injection Request
description: This rule detects potential SQL injection attempts in web server requests by identifying common SQL injection patterns in URLs. Such activity may indicate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_web_server_potential_sql_injection
products:
  - Elastic Security
---

# Web Server Potential SQL Injection Request
This rule detects potential SQL injection attempts in web server requests by identifying common SQL injection patterns
in URLs. Such activity may indicate reconnaissance or exploitation attempts by attackers trying to manipulate backend
databases or extract sensitive information.
**Rule type**: eql
**Rule indices**:
- logs-nginx.access-*
- logs-apache.access-*
- logs-apache_tomcat.access-*
- logs-iis.access-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 10m
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Web
- Use Case: Threat Detection
- Tactic: Reconnaissance
- Tactic: Credential Access
- Tactic: Persistence
- Tactic: Execution
- Tactic: Command and Control
- Data Source: Nginx
- Data Source: Apache
- Data Source: Apache Tomcat
- Data Source: IIS
- Rule Type: BBR

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
any where url.original like~ (
  "*%20order%20by%*", "*dbms_pipe.receive_message%28chr%*", "*waitfor%20delay%20*", "*%28select%20*from%20pg_sleep%285*", "*%28select%28sleep%285*", "*%3bselect%20pg_sleep%285*",
  "*select%20concat%28concat*", "*xp_cmdshell*", "*select*case*when*", "*and*extractvalue*select*", "*from*information_schema.tables*", "*boolean*mode*having*", "*extractvalue*concat*",
  "*case*when*sleep*", "*select*sleep*", "*dbms_lock.sleep*", "*and*sleep*", "*like*sleep*", "*csleep*", "*pgsleep*", "*char*char*char*", "*union*select*", "*concat*select*",
  "*select*else*drop*", "*having*like*", "*case*else*end*", "*if*sleep*", "*where*and*select*", "*or*1=1*", "*\"1\"=\"1\"*", "*or*'a'='a*", "*into*outfile*", "*pga_sleep*",
  "*into%20outfile*", "*into*dumpfile*", "*load_file%28*", "*load%5ffile%28*", "*cast%28*", "*convert%28*", "*cast%28%*", "*convert%28%*", "*@@version*", "*@@version_comment*",
  "*version%28*", "*user%28*", "*current_user%28*", "*database%28*", "*schema_name%28*", "*information_schema.columns*", "*information_schema.columns*", "*table_schema*",
  "*column_name*", "*dbms_pipe*", "*dbms_lock%2e*sleep*", "*dbms_lock.sleep*", "*sp_executesql*", "*sp_executesql*", "*load%20data*", "*information_schema*",  "*pg_slp*",
  "*information_schema.tables*"
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Server Software Component
- Id: T1505
- Reference URL: [[https://attack.mitre.org/techniques/T1505/](https://attack.mitre.org/techniques/T1505/)](https://attack.mitre.org/techniques/T1505/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Reconnaissance
- Id: TA0043
- Reference URL: [[https://attack.mitre.org/tactics/TA0043/](https://attack.mitre.org/tactics/TA0043/)](https://attack.mitre.org/tactics/TA0043/)
- Technique:
  - Name: Active Scanning
- Id: T1595
- Reference URL: [[https://attack.mitre.org/techniques/T1595/](https://attack.mitre.org/techniques/T1595/)](https://attack.mitre.org/techniques/T1595/)
- Sub Technique:
  - Name: Vulnerability Scanning
- Id: T1595.002
- Reference URL: [[https://attack.mitre.org/techniques/T1595/002/](https://attack.mitre.org/techniques/T1595/002/)](https://attack.mitre.org/techniques/T1595/002/)
- Sub Technique:
  - Name: Wordlist Scanning
- Id: T1595.003
- Reference URL: [[https://attack.mitre.org/techniques/T1595/003/](https://attack.mitre.org/techniques/T1595/003/)](https://attack.mitre.org/techniques/T1595/003/)