﻿---
title: Shortcut File Written or Modified on Startup Folder
description: Identifies shortcut files written to or modified in the startup folder. Adversaries may use this technique to maintain persistence. Rule type: eql Rule...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_startup_folder_lnk
products:
  - Elastic Security
---

# Shortcut File Written or Modified on Startup Folder
Identifies shortcut files written to or modified in the startup folder. Adversaries may use this technique to maintain
persistence.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Persistence
- Data Source: Elastic Defend
- Rule Type: BBR

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
file where host.os.type == "windows" and event.type != "deletion" and file.extension == "lnk" and
  file.path : (
    "C:\\Users\\*\\AppData\\Roaming\\Microsoft\\Windows\\Start Menu\\Programs\\Startup\\*",
    "C:\\ProgramData\\Microsoft\\Windows\\Start Menu\\Programs\\StartUp\\*"
  ) and
  not (
    (process.name : "ONENOTE.EXE" and process.code_signature.status: "trusted" and file.name : "*OneNote.lnk") or
    (process.name : "OktaVerifySetup.exe" and process.code_signature.status: "trusted" and file.name : "Okta Verify.lnk") or
    (process.name : "OneLaunch.exe" and process.code_signature.status: "trusted" and file.name : "OneLaunch*.lnk") or
    (process.name : "APPServerClient.exe" and process.code_signature.status: "trusted" and file.name : "Parallels Client.lnk")
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Registry Run Keys / Startup Folder
- Id: T1547.001
- Reference URL: [[https://attack.mitre.org/techniques/T1547/001/](https://attack.mitre.org/techniques/T1547/001/)](https://attack.mitre.org/techniques/T1547/001/)
- Sub Technique:
  - Name: Shortcut Modification
- Id: T1547.009
- Reference URL: [[https://attack.mitre.org/techniques/T1547/009/](https://attack.mitre.org/techniques/T1547/009/)](https://attack.mitre.org/techniques/T1547/009/)