﻿---
title: New User Added To GitHub Organization
description: A new user was added to a GitHub organization. Rule type: eql Rule indices: logs-github.audit-*. Rule Severity: low Risk Score: 21 Runs every:  Searches...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_github_new_user_added_to_organization
products:
  - Elastic Security
---

# New User Added To GitHub Organization
A new user was added to a GitHub organization.
**Rule type**: eql
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Use Case: UEBA
- Tactic: Persistence
- Rule Type: BBR
- Data Source: Github

**Version**: 206
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
configuration where event.dataset == "github.audit" and event.action == "org.add_member"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Cloud Credentials
- Id: T1098.001
- Reference URL: [[https://attack.mitre.org/techniques/T1098/001/](https://attack.mitre.org/techniques/T1098/001/)](https://attack.mitre.org/techniques/T1098/001/)