﻿---
title: First Occurrence of Personal Access Token (PAT) Use For a GitHub User
description: A new PAT was used for a GitHub user not previously seen in the last 14 days. Rule type: new_terms Rule indices: logs-github.audit-*. Rule Severity: low...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_github_new_pat_for_user
products:
  - Elastic Security
---

# First Occurrence of Personal Access Token (PAT) Use For a GitHub User
A new PAT was used for a GitHub user not previously seen in the last 14 days.
**Rule type**: new_terms
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Use Case: UEBA
- Tactic: Persistence
- Rule Type: BBR
- Data Source: Github

**Version**: 207
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset:"github.audit" and event.category:"configuration" and
github.hashed_token:* and user.name:* and
github.programmatic_access_type:("OAuth access token" or "Fine-grained personal access token")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Cloud Credentials
- Id: T1098.001
- Reference URL: [[https://attack.mitre.org/techniques/T1098/001/](https://attack.mitre.org/techniques/T1098/001/)](https://attack.mitre.org/techniques/T1098/001/)