﻿---
title: AWS IAM Login Profile Added to User
description: Identifies when an AWS IAM login profile is added to a user. Adversaries may add a login profile to an IAM user who typically does not have one and is...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/persistence_aws_iam_login_profile_added_to_user
products:
  - Elastic Security
---

# AWS IAM Login Profile Added to User
Identifies when an AWS IAM login profile is added to a user. Adversaries may add a login profile to an IAM user who
typically does not have one and is used only for programmatic access. This can be used to maintain access to the account
even if the original access key is rotated or disabled. This is a building block rule and does not generate alerts on
its own. It is meant to be used for correlation with other rules to detect suspicious activity.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 10m
**Searches indices from**: `now-60m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS IAM
- Use Case: Identity and Access Audit
- Tactic: Persistence
- Rule Type: BBR

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset: aws.cloudtrail and event.provider: "iam.amazonaws.com"
    and event.action: "CreateLoginProfile" and event.outcome: success
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)
- Technique:
  - Name: Account Manipulation
- Id: T1098
- Reference URL: [[https://attack.mitre.org/techniques/T1098/](https://attack.mitre.org/techniques/T1098/)](https://attack.mitre.org/techniques/T1098/)
- Sub Technique:
  - Name: Additional Cloud Roles
- Id: T1098.003
- Reference URL: [[https://attack.mitre.org/techniques/T1098/003/](https://attack.mitre.org/techniques/T1098/003/)](https://attack.mitre.org/techniques/T1098/003/)