﻿---
title: Potential Outgoing RDP Connection by Unusual Process
description: Adversaries may attempt to connect to a remote system over Windows Remote Desktop Protocol (RDP) to achieve lateral movement. Adversaries may avoid using...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/lateral_movement_rdp_conn_unusual_process
products:
  - Elastic Security
---

# Potential Outgoing RDP Connection by Unusual Process
Adversaries may attempt to connect to a remote system over Windows Remote Desktop Protocol (RDP) to achieve lateral
movement. Adversaries may avoid using the Microsoft Terminal Services Client (mstsc.exe) binary to establish an RDP
connection to evade detection.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Lateral Movement
- Data Source: Elastic Defend
- Rule Type: BBR

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
network where host.os.type == "windows" and
  event.action == "connection_attempted" and destination.port == 3389 and
  destination.ip != "::1" and destination.ip != "127.0.0.1" and
  not (
    process.executable : (
      "?:\\Windows\\System32\\mstsc.exe",
      "?:\\Program Files (x86)\\mRemoteNG\\mRemoteNG.exe",
      "?:\\Program Files (x86)\\PRTG Network Monitor\\PRTG Probe.exe",
      "?:\\Program Files\\Azure Advanced Threat Protection Sensor\\*\\Microsoft.Tri.Sensor.exe",
      "?:\\Program Files (x86)\\Microsoft\\Remote Desktop Connection Manager\\RDCMan.exe",
      "?:\\Program Files\\SentinelOne\\Sentinel Agent*\\Ranger\\SentinelRanger.exe",
      "?:\\Program Files\\Devolutions\\Remote Desktop Manager\\RemoteDesktopManager.exe",
      "?:\\Program Files (x86)\\Devolutions\\Remote Desktop Manager\\RemoteDesktopManager.exe"
    ) and process.code_signature.trusted == true
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Remote Services
- Id: T1021
- Reference URL: [[https://attack.mitre.org/techniques/T1021/](https://attack.mitre.org/techniques/T1021/)](https://attack.mitre.org/techniques/T1021/)
- Sub Technique:
  - Name: Remote Desktop Protocol
- Id: T1021.001
- Reference URL: [[https://attack.mitre.org/techniques/T1021/001/](https://attack.mitre.org/techniques/T1021/001/)](https://attack.mitre.org/techniques/T1021/001/)