﻿---
title: At.exe Command Lateral Movement
description: Identifies use of at.exe to interact with the task scheduler on remote hosts. Remote task creations, modifications or execution could be indicative of...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/lateral_movement_at
products:
  - Elastic Security
---

# At.exe Command Lateral Movement
Identifies use of at.exe to interact with the task scheduler on remote hosts. Remote task creations, modifications or
execution could be indicative of adversary lateral movement.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Lateral Movement
- Data Source: Elastic Defend
- Rule Type: BBR
- Data Source: Elastic Endgame
- Data Source: Windows Security Event Logs

**Version**: 108
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and process.name : "at.exe" and process.args : "\\\\*"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Remote Services
- Id: T1021
- Reference URL: [[https://attack.mitre.org/techniques/T1021/](https://attack.mitre.org/techniques/T1021/)](https://attack.mitre.org/techniques/T1021/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Scheduled Task/Job
- Id: T1053
- Reference URL: [[https://attack.mitre.org/techniques/T1053/](https://attack.mitre.org/techniques/T1053/)](https://attack.mitre.org/techniques/T1053/)
- Sub Technique:
  - Name: At
- Id: T1053.002
- Reference URL: [[https://attack.mitre.org/techniques/T1053/002/](https://attack.mitre.org/techniques/T1053/002/)](https://attack.mitre.org/techniques/T1053/002/)
- Sub Technique:
  - Name: Scheduled Task
- Id: T1053.005
- Reference URL: [[https://attack.mitre.org/techniques/T1053/005/](https://attack.mitre.org/techniques/T1053/005/)](https://attack.mitre.org/techniques/T1053/005/)