﻿---
title: Potential Toolshell Initial Exploit (CVE-2025-53770 & CVE-2025-53771)
description: Identifies potential exploitation of CVE-2025-53770 and CVE-2025-53771 in IIS web servers on SharePoint sites. Toolshell is an exploit chain that leverages...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_potential_toolshell_exploit_attempt
products:
  - Elastic Security
---

# Potential Toolshell Initial Exploit (CVE-2025-53770 & CVE-2025-53771)
Identifies potential exploitation of CVE-2025-53770 and CVE-2025-53771 in IIS web servers on SharePoint sites. Toolshell
is an exploit chain that leverages vulnerabilities in SharePoint/IIS to gain unauthorized access and execute commands.
This rule detects HTTP requests that match specific patterns indicative of the exploit attempt.
**Rule type**: query
**Rule indices**:
- logs-network_traffic.http*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
- [[https://research.eye.security/sharepoint-under-siege/](https://research.eye.security/sharepoint-under-siege/)](https://research.eye.security/sharepoint-under-siege/)
- [[https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-53771](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-53771)](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-53771)
- [[https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-53770](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-53770)](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-53770)
- [[https://msrc.microsoft.com/blog/2025/07/customer-guidance-for-sharepoint-vulnerability-cve-2025-53770/](https://msrc.microsoft.com/blog/2025/07/customer-guidance-for-sharepoint-vulnerability-cve-2025-53770/)](https://msrc.microsoft.com/blog/2025/07/customer-guidance-for-sharepoint-vulnerability-cve-2025-53770/)

**Tags**:
- Domain: Network
- Tactic: Initial Access
- Use Case: Exploit Detection
- Data Source: Network Traffic
- Data Source: Network Traffic HTTP Logs
- Rule Type: BBR

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

### Network Traffic Setup

This rule requires network traffic logs to be collected from HTTP endpoints, specifically focusing on IIS web servers. Ensure that your network traffic logging is configured to capture HTTP request and response details, including request and response headers. Additionally, request bodies are necessary for content-type `application/x-www-form-urlencoded` to detect potential exploit attempts.

## Rule Query

```kuery
data_stream.dataset : "network_traffic.http" and
    url.path: (/_layouts*ToolPane.aspx* or /_layouts*toolpane.aspx*) and
    http.request.referrer: *SignOut.aspx and
    network.direction: "ingress" and
    http.request.method: "POST" and
    request: (*MSOTlPn_Uri* and *DisplayMode*) and
    http.request.body.bytes >  2000
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)