﻿---
title: First Occurrence of User Agent For a GitHub Personal Access Token (PAT)
description: Detects a new user agent used for a GitHub PAT not previously seen in the last 14 days. Rule type: new_terms Rule indices: logs-github.audit-*. Rule Severity:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_github_new_user_agent_for_pat
products:
  - Elastic Security
---

# First Occurrence of User Agent For a GitHub Personal Access Token (PAT)
Detects a new user agent used for a GitHub PAT not previously seen in the last 14 days.
**Rule type**: new_terms
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Use Case: UEBA
- Tactic: Initial Access
- Rule Type: BBR
- Data Source: Github

**Version**: 207
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset:"github.audit" and event.category:"configuration" and
github.user_agent:* and github.hashed_token:* and
github.programmatic_access_type:("OAuth access token" or "Fine-grained personal access token")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)