﻿---
title: M365 Threat Intelligence Signal
description: Identifies a Microsoft 365 audit log generated for Threat Intelligence signals by Microsoft Defender for Office 365. Signals generated may relate to services...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_defender_for_m365_threat_intelligence_signal
products:
  - Elastic Security
---

# M365 Threat Intelligence Signal
Identifies a Microsoft 365 audit log generated for Threat Intelligence signals by Microsoft Defender for Office 365.
Signals generated may relate to services such as Exchange Online, SharePoint Online, OneDrive for Business and others.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-o365.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 1000
**References**:
- [[https://learn.microsoft.com/en-us/purview/audit-supported-services](https://learn.microsoft.com/en-us/purview/audit-supported-services)](https://learn.microsoft.com/en-us/purview/audit-supported-services)
- [[https://www.octiga.io/en-gb/insights/nist-csf-for-office-365](https://www.octiga.io/en-gb/insights/nist-csf-for-office-365)](https://www.octiga.io/en-gb/insights/nist-csf-for-office-365)
- [[https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-schema](https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-schema)](https://learn.microsoft.com/en-us/office/office-365-management-api/office-365-management-activity-api-schema)

**Tags**:
- Domain: Cloud
- Domain: SaaS
- Data Source: Microsoft 365
- Data Source: Microsoft 365 Audit Logs
- Data Source: Microsoft Defender
- Data Source: Microsoft Defender Threat Intelligence
- Use Case: Threat Detection
- Tactic: Initial Access
- Resources: Investigation Guide
- Rule Type: BBR

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

### Additional notes

For information on troubleshooting the maximum alerts warning please refer to this [guide](https://www.elastic.co/guide/en/security/current/alerts-ui-monitor.html#troubleshoot-max-alerts).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating M365 Threat Intelligence Signal

Microsoft 365 Threat Intelligence leverages audit logs to monitor activities across services like Exchange Online and SharePoint. Adversaries may exploit these platforms for phishing, gaining initial access. The detection rule identifies signals from Microsoft Defender, focusing on audit logs tagged with "ThreatIntelligence," to pinpoint potential abuse, assigning a medium risk score to such events.

### Possible investigation steps

- Review the audit logs filtered by event.dataset: "o365.audit" and event.provider: "ThreatIntelligence" to identify the specific activities flagged by the rule.
- Examine the user accounts associated with the flagged activities to determine if they have been compromised or are behaving anomalously.
- Investigate the source IP addresses and locations associated with the flagged events to identify any unusual or suspicious access patterns.
- Check for any related alerts or signals in Microsoft Defender for Office 365 that might provide additional context or corroborate the threat.
- Assess the potential impact on Exchange Online, SharePoint Online, and OneDrive for Business by reviewing any changes or access attempts to sensitive data or configurations.
- Determine if the flagged activities align with known phishing techniques (MITRE ATT&CK T1566) and assess the likelihood of initial access attempts.


### False positive analysis

- Routine administrative activities in Exchange Online or SharePoint Online may trigger audit logs tagged with "ThreatIntelligence" without indicating malicious intent. Review these logs to identify patterns of legitimate administrative actions and consider excluding them from the detection rule.
- Automated processes or third-party integrations with Microsoft 365 services can generate audit logs similar to those flagged by the rule. Identify these processes and create exceptions for known benign activities to reduce false positives.
- Frequent file sharing or collaboration activities in OneDrive for Business might be misinterpreted as potential threats. Analyze the context of these activities and exclude regular business operations from the rule to prevent unnecessary alerts.
- Regular updates or maintenance tasks performed by IT staff can appear as suspicious activities. Establish a baseline of expected behavior during these periods and adjust the detection rule to accommodate these known activities.
- User training sessions or onboarding processes may involve actions that mimic initial access tactics. Monitor these events and exclude them from the rule when they align with scheduled training or onboarding activities.


### Response and remediation

- Immediately isolate any affected accounts or systems identified in the audit logs to prevent further unauthorized access or data exfiltration.
- Conduct a thorough review of the audit logs to identify any additional suspicious activities or compromised accounts related to the Threat Intelligence signals.
- Reset passwords for compromised accounts and enforce multi-factor authentication to enhance security and prevent further unauthorized access.
- Notify relevant stakeholders, including IT security teams and management, about the incident and potential impact, ensuring alignment on response actions.
- Escalate the incident to Microsoft support if necessary, providing detailed information from the audit logs to assist in further investigation and resolution.
- Implement additional monitoring and alerting for similar threat indicators to enhance detection capabilities and prevent recurrence.
- Review and update security policies and configurations for Exchange Online, SharePoint Online, and OneDrive for Business to mitigate vulnerabilities exploited by adversaries.


## Rule Query

```kuery
event.dataset: "o365.audit" and event.provider: "ThreatIntelligence"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Phishing
- Id: T1566
- Reference URL: [[https://attack.mitre.org/techniques/T1566/](https://attack.mitre.org/techniques/T1566/)](https://attack.mitre.org/techniques/T1566/)