﻿---
title: AWS Sign-In Token Created
description: Captures requests to the AWS federation endpoint (signin.amazonaws.com) for GetSigninToken. This API exchanges existing temporary AWS credentials (e.g.,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_aws_signin_token_created
products:
  - Elastic Security
---

# AWS Sign-In Token Created
Captures requests to the AWS federation endpoint (signin.amazonaws.com) for GetSigninToken. This API exchanges existing
temporary AWS credentials (e.g., from STS GetFederationToken or AssumeRole) for a short-lived sign-in token that is
embedded in a one-click URL to the AWS Management Console. It is commonly used by custom federation tools and automation
to pivot from programmatic access to a browser session. This is a building block rule meant to be used for correlation
with other rules to detect suspicious activity.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-6m`
**Maximum alerts per execution**: 100
**References**:
- [[https://hackingthe.cloud/aws/post_exploitation/create_a_console_session_from_iam_credentials/](https://hackingthe.cloud/aws/post_exploitation/create_a_console_session_from_iam_credentials/)](https://hackingthe.cloud/aws/post_exploitation/create_a_console_session_from_iam_credentials/)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS Sign-In
- Use Case: Identity and Access Audit
- Tactic: Initial Access
- Rule Type: BBR

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset: "aws.cloudtrail" and 
    event.provider: "signin.amazonaws.com" and 
    event.action : "GetSigninToken" and 
    event.outcome: "success"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)
- Sub Technique:
  - Name: Cloud Accounts
- Id: T1078.004
- Reference URL: [[https://attack.mitre.org/techniques/T1078/004/](https://attack.mitre.org/techniques/T1078/004/)](https://attack.mitre.org/techniques/T1078/004/)