﻿---
title: Anomalous React Server Components Flight Data Patterns
description: This rule detects anomalous patterns in React Server Components (RSC) Flight protocol data streams that may indicate code injection or exploitation attempts...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/initial_access_anomalous_rsc_flight_data_patterns
products:
  - Elastic Security
---

# Anomalous React Server Components Flight Data Patterns
This rule detects anomalous patterns in React Server Components (RSC) Flight protocol data streams that may indicate
code injection or exploitation attempts. The Flight protocol is used by React and Next.js for server-client
communication, and should never contain Node.js code execution primitives like child_process, fs module calls, or eval
patterns. This building block rule casts a wider net to identify suspicious payloads that warrant further investigation.
**Rule type**: eql
**Rule indices**:
- logs-network_traffic.http*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
- [[https://react.dev/reference/rsc/server-components](https://react.dev/reference/rsc/server-components)](https://react.dev/reference/rsc/server-components)
- [[https://github.com/facebook/react/blob/main/packages/react-server/src/ReactFlightServer.js](https://github.com/facebook/react/blob/main/packages/react-server/src/ReactFlightServer.js)](https://github.com/facebook/react/blob/main/packages/react-server/src/ReactFlightServer.js)
- [[https://www.wiz.io/blog/critical-vulnerability-in-react-cve-2025-55182](https://www.wiz.io/blog/critical-vulnerability-in-react-cve-2025-55182)](https://www.wiz.io/blog/critical-vulnerability-in-react-cve-2025-55182)
- [[https://slcyber.io/research-center/high-fidelity-detection-mechanism-for-rsc-next-js-rce-cve-2025-55182-cve-2025-66478/](https://slcyber.io/research-center/high-fidelity-detection-mechanism-for-rsc-next-js-rce-cve-2025-55182-cve-2025-66478/)](https://slcyber.io/research-center/high-fidelity-detection-mechanism-for-rsc-next-js-rce-cve-2025-55182-cve-2025-66478/)
- [[https://nextjs.org/docs/app/building-your-application/rendering/server-components](https://nextjs.org/docs/app/building-your-application/rendering/server-components)](https://nextjs.org/docs/app/building-your-application/rendering/server-components)
- [[https://tonyalicea.dev/blog/understanding-react-server-components/](https://tonyalicea.dev/blog/understanding-react-server-components/)](https://tonyalicea.dev/blog/understanding-react-server-components/)

**Tags**:
- Domain: Network
- Domain: Application
- Domain: Web
- Use Case: Threat Detection
- Tactic: Initial Access
- Tactic: Execution
- Data Source: Network Packet Capture
- Rule Type: BBR

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
network where http.request.method == "POST" and http.response.status_code != 200 and
(
    // Node.js child_process module
    (
        http.request.body.content like~ "*require('child_process')*" or
        http.request.body.content like~ "*require(\"child_process\")*" or
        http.request.body.content like~ "*child_process*" and http.request.body.content like~ "*.exec*"
    ) or
    // Node.js synchronous execution methods
    (
        http.request.body.content like~ "*.execSync(*" or
        http.request.body.content like~ "*.spawnSync(*" or
        http.request.body.content like~ "*.execFileSync(*"
    ) or
    // Node.js file system operations - suspicious in RSC context
    (
        http.request.body.content like~ "*require('fs')*" or
        http.request.body.content like~ "*require(\"fs\")*" or
        http.request.body.content like~ "*.readFileSync(*" or
        http.request.body.content like~ "*.writeFileSync(*" or
        http.request.body.content like~ "*.unlinkSync(*"
    ) or
    // Process and module access patterns used in exploitation
    (
        http.request.body.content like~ "*process.mainModule*" or
        http.request.body.content like~ "*process.binding*" or
        http.request.body.content like~ "*process.dlopen*"
    ) or
    // JavaScript code execution primitives
    (
        http.request.body.content like~ "*eval(*" and http.request.body.content like~ "*require*" or
        http.request.body.content like~ "*Function(*" and http.request.body.content like~ "*return*"
    ) or
    // Generic prototype pollution indicators
    (
        http.request.body.content like~ "*prototype*" and http.request.body.content like~ "*constructor*"
    )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: JavaScript
- Id: T1059.007
- Reference URL: [[https://attack.mitre.org/techniques/T1059/007/](https://attack.mitre.org/techniques/T1059/007/)](https://attack.mitre.org/techniques/T1059/007/)