﻿---
title: GitHub User Blocked From Organization
description: A GitHub user was blocked from access to an organization. Rule type: eql Rule indices: logs-github.audit-*. Rule Severity: low Risk Score: 21 Runs every:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/impact_github_user_blocked_from_organization
products:
  - Elastic Security
---

# GitHub User Blocked From Organization
A GitHub user was blocked from access to an organization.
**Rule type**: eql
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Use Case: UEBA
- Tactic: Impact
- Rule Type: BBR
- Data Source: Github

**Version**: 206
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
configuration where event.dataset == "github.audit" and event.action == "org.block_user"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Account Access Removal
- Id: T1531
- Reference URL: [[https://attack.mitre.org/techniques/T1531/](https://attack.mitre.org/techniques/T1531/)](https://attack.mitre.org/techniques/T1531/)