﻿---
title: Member Removed From GitHub Organization
description: A member was removed or their invitation to join was removed from a GitHub Organization. Rule type: eql Rule indices: logs-github.audit-*. Rule Severity:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/impact_github_member_removed_from_organization
products:
  - Elastic Security
---

# Member Removed From GitHub Organization
A member was removed or their invitation to join was removed from a GitHub Organization.
**Rule type**: eql
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Use Case: UEBA
- Tactic: Impact
- Rule Type: BBR
- Data Source: Github

**Version**: 206
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
configuration where event.dataset == "github.audit" and event.action == "org.remove_member"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Account Access Removal
- Id: T1531
- Reference URL: [[https://attack.mitre.org/techniques/T1531/](https://attack.mitre.org/techniques/T1531/)](https://attack.mitre.org/techniques/T1531/)