﻿---
title: Azure Recovery Services Resource Deleted
description: Identifies the deletion of Azure Recovery Services resources. Azure Recovery Services vaults contain data for copies of VMs, workloads, servers, and other...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/impact_azure_recovery_services_deletion
products:
  - Elastic Security
---

# Azure Recovery Services Resource Deleted
Identifies the deletion of Azure Recovery Services resources. Azure Recovery Services vaults contain data for copies of
VMs, workloads, servers, and other resources regarding Infrastructure as a Service (IaaS). Adversaries may delete these
recovery services to impact backup capabilities during stable operations or to inhibit disaster recovery services during
ransom-based attacks or operational disruptions.
**Rule type**: query
**Rule indices**:
- logs-azure.activitylogs-*
- filebeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.microsoft.com/en-us/security/blog/2023/07/25/storm-0501-ransomware-attacks-expanding-to-hybrid-cloud-environments/](https://www.microsoft.com/en-us/security/blog/2023/07/25/storm-0501-ransomware-attacks-expanding-to-hybrid-cloud-environments/)](https://www.microsoft.com/en-us/security/blog/2023/07/25/storm-0501-ransomware-attacks-expanding-to-hybrid-cloud-environments/)

**Tags**:
- Domain: Cloud
- Domain: Storage
- Data Source: Azure
- Data Source: Azure Activity Logs
- Use Case: Threat Detection
- Tactic: Impact
- Resources: Investigation Guide
- Rule Type: BBR

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset:azure.activitylogs and
    azure.activitylogs.operation_name:MICROSOFT.RECOVERYSERVICES/*/DELETE and
    event.outcome:(Success or success)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Inhibit System Recovery
- Id: T1490
- Reference URL: [[https://attack.mitre.org/techniques/T1490/](https://attack.mitre.org/techniques/T1490/)](https://attack.mitre.org/techniques/T1490/)