﻿---
title: WMI WBEMTEST Utility Execution
description: Adversaries may abuse the WMI diagnostic tool, wbemtest.exe, to enumerate WMI object instances or invoke methods against local or remote endpoints. Rule...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_wmi_wbemtest
products:
  - Elastic Security
---

# WMI WBEMTEST Utility Execution
Adversaries may abuse the WMI diagnostic tool, wbemtest.exe, to enumerate WMI object instances or invoke methods against
local or remote endpoints.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-endpoint.events.process-*
- logs-system.security*
- logs-windows.*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 60m
**Searches indices from**: `now-119m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Data Source: Elastic Defend
- Rule Type: BBR
- Data Source: Elastic Endgame
- Data Source: Windows Security Event Logs

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
process where host.os.type == "windows" and event.type == "start" and process.name : "wbemtest.exe"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Windows Management Instrumentation
- Id: T1047
- Reference URL: [[https://attack.mitre.org/techniques/T1047/](https://attack.mitre.org/techniques/T1047/)](https://attack.mitre.org/techniques/T1047/)