﻿---
title: Execution of an Unsigned Service
description: This rule identifies the execution of unsigned executables via service control manager (SCM). Adversaries may abuse SCM to execute malware or escalate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_unsigned_service_executable
products:
  - Elastic Security
---

# Execution of an Unsigned Service
This rule identifies the execution of unsigned executables via service control manager (SCM). Adversaries may abuse SCM
to execute malware or escalate privileges.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Defense Evasion
- Rule Type: BBR
- Data Source: Elastic Defend

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
host.os.type:windows and event.category:process and event.type:start and 
process.parent.executable:"C:\\Windows\\System32\\services.exe" and 
(process.code_signature.exists:false or process.code_signature.trusted:false) and
not process.code_signature.status : (errorCode_endpoint* or "errorChaining")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: System Services
- Id: T1569
- Reference URL: [[https://attack.mitre.org/techniques/T1569/](https://attack.mitre.org/techniques/T1569/)](https://attack.mitre.org/techniques/T1569/)
- Sub Technique:
  - Name: Service Execution
- Id: T1569.002
- Reference URL: [[https://attack.mitre.org/techniques/T1569/002/](https://attack.mitre.org/techniques/T1569/002/)](https://attack.mitre.org/techniques/T1569/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Invalid Code Signature
- Id: T1036.001
- Reference URL: [[https://attack.mitre.org/techniques/T1036/001/](https://attack.mitre.org/techniques/T1036/001/)](https://attack.mitre.org/techniques/T1036/001/)