﻿---
title: Creation of SettingContent-ms Files
description: Identifies the suspicious creation of SettingContents-ms files, which have been used in attacks to achieve code execution while evading defenses. Rule...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_settingcontent_ms_file_creation
products:
  - Elastic Security
---

# Creation of SettingContent-ms Files
Identifies the suspicious creation of SettingContents-ms files, which have been used in attacks to achieve code
execution while evading defenses.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file-*
- logs-windows.sysmon_operational-*
- endgame-*
- winlogbeat-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://posts.specterops.io/the-tale-of-settingcontent-ms-files-f1ea253e4d39](https://posts.specterops.io/the-tale-of-settingcontent-ms-files-f1ea253e4d39)](https://posts.specterops.io/the-tale-of-settingcontent-ms-files-f1ea253e4d39)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Threat Detection
- Tactic: Execution
- Data Source: Elastic Defend
- Rule Type: BBR
- Data Source: Sysmon
- Data Source: Elastic Endgame

**Version**: 108
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
file where host.os.type == "windows" and event.type == "creation" and
  file.extension : "settingcontent-ms" and
  not file.path : (
    "?:\\*\\AppData\\Local\\Packages\\windows.immersivecontrolpanel_*\\LocalState\\Indexed\\Settings\\*",
    "\\Device\\HarddiskVolume*\\Windows\\WinSxS\\amd64_microsoft-windows-s..*\\*.settingcontent-ms"
  )
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: User Execution
- Id: T1204
- Reference URL: [[https://attack.mitre.org/techniques/T1204/](https://attack.mitre.org/techniques/T1204/)](https://attack.mitre.org/techniques/T1204/)
- Sub Technique:
  - Name: Malicious File
- Id: T1204.002
- Reference URL: [[https://attack.mitre.org/techniques/T1204/002/](https://attack.mitre.org/techniques/T1204/002/)](https://attack.mitre.org/techniques/T1204/002/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Phishing
- Id: T1566
- Reference URL: [[https://attack.mitre.org/techniques/T1566/](https://attack.mitre.org/techniques/T1566/)](https://attack.mitre.org/techniques/T1566/)
- Sub Technique:
  - Name: Spearphishing Attachment
- Id: T1566.001
- Reference URL: [[https://attack.mitre.org/techniques/T1566/001/](https://attack.mitre.org/techniques/T1566/001/)](https://attack.mitre.org/techniques/T1566/001/)