﻿---
title: First Occurrence of GitHub Repo Interaction From a New IP
description: Detects an interaction with a private GitHub repository from a new IP address not seen in the last 14 days. Rule type: new_terms Rule indices: logs-github.audit-*...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_github_repo_interaction_from_new_ip
products:
  - Elastic Security
---

# First Occurrence of GitHub Repo Interaction From a New IP
Detects an interaction with a private GitHub repository from a new IP address not seen in the last 14 days.
**Rule type**: new_terms
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Use Case: UEBA
- Tactic: Execution
- Rule Type: BBR
- Data Source: Github

**Version**: 207
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset:"github.audit" and event.category:"configuration" and
github.actor_ip:* and github.repo:* and 
github.repository_public:false
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Serverless Execution
- Id: T1648
- Reference URL: [[https://attack.mitre.org/techniques/T1648/](https://attack.mitre.org/techniques/T1648/)](https://attack.mitre.org/techniques/T1648/)