﻿---
title: GitHub Repo Created
description: A new GitHub repository was created. Rule type: eql Rule indices: logs-github.audit-*. Rule Severity: low Risk Score: 21 Runs every:  Searches indices...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_github_repo_created
products:
  - Elastic Security
---

# GitHub Repo Created
A new GitHub repository was created.
**Rule type**: eql
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Use Case: UEBA
- Tactic: Execution
- Rule Type: BBR
- Data Source: Github

**Version**: 206
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```eql
configuration where event.dataset == "github.audit" and event.action == "repo.create"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Serverless Execution
- Id: T1648
- Reference URL: [[https://attack.mitre.org/techniques/T1648/](https://attack.mitre.org/techniques/T1648/)](https://attack.mitre.org/techniques/T1648/)