﻿---
title: First Occurrence GitHub Event for a Personal Access Token (PAT)
description: Detects a first occurrence event for a personal access token (PAT) not seen in the last 14 days. Rule type: new_terms Rule indices: logs-github.audit-*...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_github_new_event_action_for_pat
products:
  - Elastic Security
---

# First Occurrence GitHub Event for a Personal Access Token (PAT)
Detects a first occurrence event for a personal access token (PAT) not seen in the last 14 days.
**Rule type**: new_terms
**Rule indices**:
- logs-github.audit-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Cloud
- Use Case: Threat Detection
- Use Case: UEBA
- Tactic: Execution
- Rule Type: BBR
- Data Source: Github

**Version**: 207
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset:"github.audit" and event.category:"configuration" and
event.action:* and github.hashed_token:* and 
github.programmatic_access_type:("OAuth access token" or "Fine-grained personal access token")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Serverless Execution
- Id: T1648
- Reference URL: [[https://attack.mitre.org/techniques/T1648/](https://attack.mitre.org/techniques/T1648/)](https://attack.mitre.org/techniques/T1648/)