﻿---
title: AWS Lambda Function Created or Updated
description: Identifies when an AWS Lambda function is created or updated. AWS Lambda lets you run code without provisioning or managing servers. Adversaries can create...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/execution_aws_lambda_function_updated
products:
  - Elastic Security
---

# AWS Lambda Function Created or Updated
Identifies when an AWS Lambda function is created or updated. AWS Lambda lets you run code without provisioning or
managing servers. Adversaries can create or update Lambda functions to execute malicious code, exfiltrate data, or
escalate privileges. This is a [building block
rule](https://www.elastic.co/guide/en/security/current/building-block-rule.html) that does not generate alerts, but
signals when a Lambda function is created or updated that matches the rule's conditions. To generate alerts, create a
rule that uses this signal as a building block.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-aws.cloudtrail-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 10m
**Searches indices from**: `now-60m`
**Maximum alerts per execution**: 100
**References**:
- [[https://mattslifebytes.com/2023/04/14/from-rebuilds-to-reloads-hacking-aws-lambda-to-enable-instant-code-updates/](https://mattslifebytes.com/2023/04/14/from-rebuilds-to-reloads-hacking-aws-lambda-to-enable-instant-code-updates/)](https://mattslifebytes.com/2023/04/14/from-rebuilds-to-reloads-hacking-aws-lambda-to-enable-instant-code-updates/)
- [[https://stratus-red-team.cloud/attack-techniques/AWS/aws.persistence.lambda-overwrite-code/](https://stratus-red-team.cloud/attack-techniques/AWS/aws.persistence.lambda-overwrite-code/)](https://stratus-red-team.cloud/attack-techniques/AWS/aws.persistence.lambda-overwrite-code/)
- [[https://docs.aws.amazon.com/lambda/latest/api/API_UpdateFunctionCode.html](https://docs.aws.amazon.com/lambda/latest/api/API_UpdateFunctionCode.html)](https://docs.aws.amazon.com/lambda/latest/api/API_UpdateFunctionCode.html)

**Tags**:
- Domain: Cloud
- Data Source: AWS
- Data Source: Amazon Web Services
- Data Source: AWS Lambda
- Use Case: Asset Visibility
- Tactic: Execution
- Rule Type: BBR

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset: "aws.cloudtrail"
    and event.provider: "lambda.amazonaws.com"
    and event.outcome: "success"
    and event.action: (CreateFunction* or UpdateFunctionCode*)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Serverless Execution
- Id: T1648
- Reference URL: [[https://attack.mitre.org/techniques/T1648/](https://attack.mitre.org/techniques/T1648/)](https://attack.mitre.org/techniques/T1648/)