﻿---
title: Entra ID Protection - Risk Detection
description: Identifies Microsoft Entra ID Protection sign-in risk detections triggered by a range of risk events such as anonymized IP addresses, password spray attacks,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules_building_block/entra_id_identity_protection_risk_detections
products:
  - Elastic Security
---

# Entra ID Protection - Risk Detection
Identifies Microsoft Entra ID Protection sign-in risk detections triggered by a range of risk events such as anonymized
IP addresses, password spray attacks, impossible travel, token anomalies, and more. These detections are often early
indicators of potential account compromise or malicious sign-in behavior. This is a promotion rule intended to surface
all Entra ID sign-in risk events for further investigation and correlation with other identity-related activity. This is
a building block rule that is used to collect all Microsoft Entra ID Protection sign-in or user risk detections. It is
not intended to be used as a standalone detection.
**Rule type**: query
**Rule indices**:
- logs-azure.identity_protection-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://learn.microsoft.com/en-us/entra/id-protection/concept-identity-protection-risks#risk-types-and-detection](https://learn.microsoft.com/en-us/entra/id-protection/concept-identity-protection-risks#risk-types-and-detection)](https://learn.microsoft.com/en-us/entra/id-protection/concept-identity-protection-risks#risk-types-and-detection)

**Tags**:
- Domain: Cloud
- Data Source: Azure
- Data Source: Microsoft Entra ID
- Data Source: Microsoft Entra ID Protection
- Data Source: Microsoft Entra ID Protection Logs
- Use Case: Identity and Access Audit
- Use Case: Threat Detection
- Rule Type: BBR

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Rule Query

```kuery
event.dataset: "azure.identity_protection"
```